/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.ai.statemachine.AIOneTimeEventTarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.modules.settings.FollowModeSetting;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import com.minecolonies.coremod.items.AbstractItemScroll;
import com.minecolonies.coremod.network.messages.client.VanillaParticleMessage;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ItemScrollGuardHelp
extends AbstractItemScroll {
    public ItemScrollGuardHelp(Item.Properties properties) {
        super("scroll_guard_help", properties);
    }

    @Override
    protected ItemStack onItemUseSuccess(ItemStack itemStack, World world, ServerPlayerEntity player) {
        IColony colony = this.getColony(itemStack);
        BlockPos buildingPos = BlockPosUtil.read(itemStack.func_77978_p(), "building_pos");
        IBuilding building = colony.getBuildingManager().getBuilding(buildingPos);
        if (!(building instanceof AbstractBuildingGuards)) {
            LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"minecolonies.scroll.noguardbuilding", (Object[])new Object[0]);
            return itemStack;
        }
        itemStack.func_190918_g(1);
        List<ICitizenData> guards = building.getAssignedCitizen();
        if (world.field_73012_v.nextInt(10) == 0 || colony.getWorld() != world) {
            LlamaEntity entity = (LlamaEntity)EntityType.field_200769_I.func_200721_a(world);
            entity.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            world.func_217376_c((Entity)entity);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("minecolonies.scroll.failed" + (world.field_73012_v.nextInt(10) + 1)).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GOLD)), true);
            SoundUtils.playSoundForPlayer(player, SoundEvents.field_191244_bn, 0.5f, 1.0f);
            return itemStack;
        }
        for (ICitizenData citizenData : guards) {
            AbstractJobGuard job = citizenData.getJob(AbstractJobGuard.class);
            if (job != null && job.getWorkerAI() != null && !((AbstractEntityAIGuard)job.getWorkerAI()).hasTool()) continue;
            if (citizenData.getEntity().isPresent()) {
                if (citizenData.getEntity().get().getCitizenDiseaseHandler().isSick()) continue;
                citizenData.getEntity().get().func_70106_y();
            }
            colony.getCitizenManager().spawnOrCreateCivilian(citizenData, world, player.func_233580_cy_(), true);
            citizenData.setNextRespawnPosition(buildingPos);
            ((AbstractBuildingGuards)building).getSetting(AbstractBuildingGuards.GUARD_TASK).set("com.minecolonies.core.guard.setting.follow");
            ((AbstractBuildingGuards)building).setPlayerToFollow((PlayerEntity)player);
            FollowModeSetting grouping = ((AbstractBuildingGuards)building).getSetting(AbstractBuildingGuards.FOLLOW_MODE);
            if (grouping.getValue().equals(FollowModeSetting.LOOSE)) {
                grouping.trigger();
            }
            citizenData.setSaturation(100.0);
            colony.getPackageManager().addCloseSubscriber(player);
            if (job == null || job.getWorkerAI() == null) continue;
            long spawnTime = world.func_82737_E() + 18000L;
            job.getWorkerAI().registerTarget(new AIOneTimeEventTarget(() -> {
                if (world.func_82737_E() - spawnTime > 0L) {
                    ((AbstractBuildingGuards)building).getSetting(AbstractBuildingGuards.GUARD_TASK).set("com.minecolonies.core.guard.setting.patrol");
                    citizenData.getEntity().ifPresent(Entity::func_70106_y);
                    colony.getPackageManager().removeCloseSubscriber(player);
                    return true;
                }
                return false;
            }, AIWorkerState.DECIDE));
        }
        SoundUtils.playSoundForPlayer(player, SoundEvents.field_194228_if, 0.3f, 1.0f);
        return itemStack;
    }

    @Override
    protected boolean needsColony() {
        return true;
    }

    @Override
    @NotNull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        IBuilding building;
        ActionResultType result = super.func_195939_a(ctx);
        if (ctx.func_195991_k().field_72995_K) {
            return result;
        }
        TileEntity te = ctx.func_195991_k().func_175625_s(ctx.func_195995_a());
        if (te instanceof TileEntityColonyBuilding && ctx.func_195999_j() != null && !((building = ((TileEntityColonyBuilding)te).getColony().getBuildingManager().getBuilding(ctx.func_195995_a())) instanceof AbstractBuildingGuards)) {
            LanguageHandler.sendPlayerMessage((PlayerEntity)ctx.func_195999_j(), (String)"minecolonies.scroll.noguardbuilding", (Object[])new Object[0]);
        }
        return result;
    }

    public void func_219972_a(World worldIn, LivingEntity entity, ItemStack stack, int count) {
        if (!worldIn.field_72995_K && worldIn.func_82737_E() % 5L == 0L) {
            Network.getNetwork().sendToTrackingEntity(new VanillaParticleMessage(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), ParticleTypes.field_197623_p), (Entity)entity);
            Network.getNetwork().sendToPlayer(new VanillaParticleMessage(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), ParticleTypes.field_197623_p), (ServerPlayerEntity)entity);
        }
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        IFormattableTextComponent guiHint = LanguageHandler.buildChatComponent((String)"item.minecolonies.scroll_guard_help.tip", (Object[])new Object[0]);
        guiHint.func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.DARK_GREEN));
        tooltip.add((ITextComponent)guiHint);
        String colonyDesc = new TranslationTextComponent("item.minecolonies.scroll.colony.none").getString();
        IColony colony = this.getColonyView(stack);
        if (colony != null) {
            colonyDesc = colony.getName();
        }
        TranslationTextComponent guiHint2 = new TranslationTextComponent("item.minecolonies.scroll.colony.tip", new Object[]{colonyDesc});
        guiHint2.func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GOLD));
        tooltip.add((ITextComponent)guiHint2);
    }
}

